/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.arm;

import jpcsp.arm.ARMDecoder;
import jpcsp.arm.ARMInstruction;
import jpcsp.arm.ARMInterpreter;
import jpcsp.arm.ARMMemory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ARMProcessor {
    public static Logger log = Logger.getLogger((String)"arm");
    public static final int MODE_USER = 0;
    public static final int MODE_FIQ = 1;
    public static final int MODE_IRQ = 2;
    public static final int MODE_SUPERVISOR = 3;
    public static final int MODE_ABORT = 4;
    public static final int MODE_UNDEFINED = 5;
    public static final int MODE_SYSTEM = 6;
    public static final int COPROCESSOR_SYSTEM_CONTROL = 15;
    public static final int REG_R0 = 0;
    public static final int REG_R1 = 1;
    public static final int REG_R2 = 2;
    public static final int REG_R3 = 3;
    public static final int REG_R4 = 4;
    public static final int REG_R5 = 5;
    public static final int REG_R6 = 6;
    public static final int REG_R7 = 7;
    public static final int REG_R8 = 8;
    public static final int REG_R9 = 9;
    public static final int REG_R10 = 10;
    public static final int REG_R11 = 11;
    public static final int REG_R12 = 12;
    public static final int REG_SP = 13;
    public static final int REG_LR = 14;
    public static final int REG_PC = 15;
    public static final int NUMBER_REGISTERS = 16;
    public static final int CPSR_BIT_N = 31;
    public static final int CPSR_BIT_Z = 30;
    public static final int CPSR_BIT_C = 29;
    public static final int CPSR_BIT_V = 28;
    public static final int CPSR_BIT_I = 7;
    public static final int CPSR_BIT_F = 6;
    public static final int CPSR_BIT_T = 5;
    private static final int CPSR_NZ_FLAGS = Utilities.getFlagFromBit(31) | Utilities.getFlagFromBit(30);
    private static final int CPSR_NZC_FLAGS = CPSR_NZ_FLAGS | Utilities.getFlagFromBit(29);
    private static final int CPSR_NZCV_FLAGS = CPSR_NZC_FLAGS | Utilities.getFlagFromBit(28);
    private int processorMode;
    private final int[] gpr = new int[13];
    private final int[] gpr_fiq = new int[5];
    private final int[] gpr_sp = new int[6];
    private static final int[] gpr_sp_mode_mapping = new int[]{0, 1, 2, 3, 4, 5, 0};
    private final int[] gpr_lr = new int[6];
    private static final int[] gpr_lr_mode_mapping = new int[]{0, 1, 2, 3, 4, 5, 0};
    private final int[] spsr = new int[5];
    private static final int[] spsr_mode_mapping = new int[]{-1, 0, 1, 2, 3, 4, -1};
    private static final int[] cpsr_mode_bits = new int[]{16, 17, 18, 19, 23, 27, 31};
    private int pc;
    private int cpsr;
    private boolean thumbMode;
    public ARMMemory mem;
    public ARMInterpreter interpreter;
    private int currentInstructionPc;
    public boolean shifterCarryOut;
    private boolean highVectors = false;

    public ARMProcessor(ARMMemory mem) {
        this.mem = mem;
        mem.setProcessor(this);
        this.setProcessorMode(0);
    }

    public void setInterpreter(ARMInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public void interpret() {
        if (this.thumbMode) {
            this.interpretThumb();
        } else {
            this.interpretARM();
        }
    }

    private void interpretThumb() {
        this.currentInstructionPc = this.pc;
        int insn = this.mem.internalRead16(this.pc);
        this.pc += 2;
        ARMInstruction instruction = ARMDecoder.thumbInstruction(insn);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X: [0x%04X] - %s", this.currentInstructionPc, insn, instruction.disasm(this.currentInstructionPc, insn)));
        }
        instruction.interpret(this, insn);
    }

    private void interpretARM() {
        this.currentInstructionPc = this.pc;
        int insn = this.mem.internalRead32(this.pc);
        this.pc += 4;
        ARMInstruction instruction = ARMDecoder.instruction(insn);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X: [0x%08X] - %s", this.currentInstructionPc, insn, instruction.disasm(this.currentInstructionPc, insn)));
        }
        instruction.interpret(this, insn);
    }

    public void setThumbMode() {
        this.setCpsrBit(5);
        this.thumbMode = true;
    }

    public void setARMMode() {
        this.clearCpsrBit(5);
        this.thumbMode = false;
    }

    public int getProcessorMode() {
        return this.processorMode;
    }

    public void setProcessorMode(int processorMode) {
        this.processorMode = processorMode;
        this.cpsr = Utilities.clearFlag(this.cpsr, 31);
        this.cpsr = Utilities.setFlag(this.cpsr, cpsr_mode_bits[processorMode]);
    }

    public boolean inAPrivilegeMode() {
        return this.processorMode != 0;
    }

    public int getSpsr() {
        return this.spsr[spsr_mode_mapping[this.processorMode]];
    }

    public void setSpsr(int value) {
        this.setSpsr(value, this.processorMode);
    }

    public boolean currentModeHasSpsr() {
        return spsr_mode_mapping[this.processorMode] >= 0;
    }

    private void setSpsr(int value, int processorMode) {
        this.spsr[ARMProcessor.spsr_mode_mapping[processorMode]] = value;
    }

    private void clearCpsrBit(int bit) {
        this.cpsr = Utilities.clearBit(this.cpsr, bit);
    }

    private void setCpsrBit(int bit) {
        this.cpsr = Utilities.setBit(this.cpsr, bit);
    }

    private boolean hasCpsrBit(int bit) {
        return Utilities.hasBit(this.cpsr, bit);
    }

    public boolean isInterruptEnabled() {
        return !this.hasCpsrBit(7);
    }

    public void setInterruptEnabled() {
        this.clearCpsrBit(7);
    }

    public void setInterruptDisabled() {
        this.setCpsrBit(7);
    }

    public void resetException() {
        this.setProcessorMode(3);
        this.setSpsr(0);
        this.setLr(0);
        this.clearCpsrBit(5);
        this.thumbMode = false;
        this.setCpsrBit(6);
        this.setCpsrBit(7);
        if (this.highVectors) {
            this.setPc(-65536);
        } else {
            this.setPc(0);
        }
    }

    public void undefinedInstructionException() {
        this.setProcessorMode(5);
        this.setLr(this.pc);
        this.setSpsr(this.cpsr);
        this.clearCpsrBit(5);
        this.thumbMode = false;
        this.setCpsrBit(7);
        if (this.highVectors) {
            this.setPc(-65532);
        } else {
            this.setPc(4);
        }
    }

    public void softwareInterruptException() {
        this.setProcessorMode(3);
        this.setLr(this.pc);
        this.setSpsr(this.cpsr);
        this.clearCpsrBit(5);
        this.thumbMode = false;
        this.setCpsrBit(7);
        if (this.highVectors) {
            this.setPc(-65528);
        } else {
            this.setPc(8);
        }
    }

    public void prefetchAbortException() {
        this.setProcessorMode(4);
        this.setLr(this.pc);
        this.setSpsr(this.cpsr);
        this.clearCpsrBit(5);
        this.thumbMode = false;
        this.setCpsrBit(7);
        if (this.highVectors) {
            this.setPc(-65524);
        } else {
            this.setPc(12);
        }
    }

    public void interruptRequestException() {
        this.setProcessorMode(2);
        this.setLr(this.pc + 4);
        this.setSpsr(this.cpsr);
        this.clearCpsrBit(5);
        this.thumbMode = false;
        this.setCpsrBit(7);
        if (this.highVectors) {
            this.setPc(-65512);
        } else {
            this.setPc(24);
        }
    }

    public void fastInterruptRequestException() {
        this.setProcessorMode(1);
        this.setLr(this.pc + 4);
        this.setSpsr(this.cpsr);
        this.clearCpsrBit(5);
        this.thumbMode = false;
        this.setCpsrBit(6);
        this.setCpsrBit(7);
        if (this.highVectors) {
            this.setPc(-65508);
        } else {
            this.setPc(28);
        }
    }

    public int getRegister(int n) {
        if (n < this.gpr.length) {
            return this.gpr[n];
        }
        switch (n) {
            case 13: {
                return this.getSp();
            }
            case 14: {
                return this.getLr();
            }
            case 15: {
                return this.getPc();
            }
        }
        log.error((Object)String.format("Unknown register 0x%X", n));
        return 0;
    }

    public int getSp() {
        return this.gpr_sp[gpr_sp_mode_mapping[this.processorMode]];
    }

    public int getLr() {
        return this.gpr_lr[gpr_lr_mode_mapping[this.processorMode]];
    }

    public void setRegister(int n, int value) {
        if (n < 8) {
            this.gpr[n] = value;
        } else if (n < 13) {
            if (this.processorMode == 1) {
                this.gpr_fiq[n - 8] = value;
            } else {
                this.gpr[n] = value;
            }
        } else {
            switch (n) {
                case 13: {
                    this.setSp(value);
                    break;
                }
                case 14: {
                    this.setLr(value);
                    break;
                }
                case 15: {
                    this.setPc(value);
                    break;
                }
                default: {
                    log.error((Object)String.format("Unknown register 0x%X", n));
                }
            }
        }
    }

    public void setSp(int value) {
        this.gpr_sp[ARMProcessor.gpr_sp_mode_mapping[this.processorMode]] = value;
    }

    public void setLr(int value) {
        this.gpr_lr[ARMProcessor.gpr_lr_mode_mapping[this.processorMode]] = value;
    }

    public int getPc() {
        if (this.thumbMode) {
            return this.pc + 2;
        }
        return this.pc + 4;
    }

    private void setPc(int value) {
        this.pc = value;
    }

    public int getCurrentInstructionPc() {
        return this.currentInstructionPc;
    }

    public int getNextInstructionPc() {
        return this.pc;
    }

    public boolean isNextInstructionPc(int addr) {
        return this.pc == addr;
    }

    public void link() {
        this.setLr(this.pc);
    }

    public void linkWithThumb() {
        this.setLr(this.pc | 1);
    }

    public void branch(int offset) {
        this.setPc(this.getPc() + offset);
    }

    public void branchWithLink(int offset) {
        this.link();
        this.branch(offset);
    }

    public void jumpWithMode(int addr) {
        if (Utilities.hasBit(addr, 0)) {
            if (!this.thumbMode) {
                this.setThumbMode();
            }
            addr = Utilities.clearBit(addr, 0);
        } else if (this.thumbMode) {
            this.setARMMode();
        }
        this.jump(addr);
    }

    public void jump(int addr) {
        this.setPc(addr);
    }

    public boolean isCondition(int insn) {
        return this.isConditionCode(insn >>> 28);
    }

    public boolean isConditionCode(int code) {
        switch (code) {
            case 0: {
                return Utilities.hasBit(this.cpsr, 30);
            }
            case 1: {
                return !Utilities.hasBit(this.cpsr, 30);
            }
            case 2: {
                return Utilities.hasBit(this.cpsr, 29);
            }
            case 3: {
                return !Utilities.hasBit(this.cpsr, 29);
            }
            case 4: {
                return Utilities.hasBit(this.cpsr, 31);
            }
            case 5: {
                return !Utilities.hasBit(this.cpsr, 31);
            }
            case 6: {
                return Utilities.hasBit(this.cpsr, 28);
            }
            case 7: {
                return !Utilities.hasBit(this.cpsr, 28);
            }
            case 8: {
                return Utilities.hasBit(this.cpsr, 29) && !Utilities.hasBit(this.cpsr, 30);
            }
            case 9: {
                return !Utilities.hasBit(this.cpsr, 29) || Utilities.hasBit(this.cpsr, 30);
            }
            case 10: {
                return Utilities.hasBit(this.cpsr, 31) == Utilities.hasBit(this.cpsr, 28);
            }
            case 11: {
                return Utilities.hasBit(this.cpsr, 31) != Utilities.hasBit(this.cpsr, 28);
            }
            case 12: {
                return !Utilities.hasBit(this.cpsr, 30) && Utilities.hasBit(this.cpsr, 31) == Utilities.hasBit(this.cpsr, 28);
            }
            case 13: {
                return Utilities.hasBit(this.cpsr, 30) || Utilities.hasBit(this.cpsr, 31) != Utilities.hasBit(this.cpsr, 28);
            }
            case 14: {
                return true;
            }
        }
        log.error((Object)String.format("Unknown condition code 0x%X", code));
        return false;
    }

    public int getCpsr() {
        return this.cpsr;
    }

    public void setCpsr(int cpsr) {
        this.cpsr = cpsr;
        switch (cpsr & 0x1F) {
            case 16: {
                this.setProcessorMode(0);
                break;
            }
            case 17: {
                this.setProcessorMode(1);
                break;
            }
            case 18: {
                this.setProcessorMode(2);
                break;
            }
            case 19: {
                this.setProcessorMode(3);
                break;
            }
            case 23: {
                this.setProcessorMode(4);
                break;
            }
            case 27: {
                this.setProcessorMode(5);
                break;
            }
            case 31: {
                this.setProcessorMode(6);
                break;
            }
            default: {
                log.error((Object)String.format("Unknown CPSR Modes bits 0x%02X", cpsr & 0x1F));
            }
        }
        if (Utilities.hasBit(cpsr, 5)) {
            this.setThumbMode();
        } else {
            this.setARMMode();
        }
    }

    public void setCpsrfromSpsr() {
        this.setCpsr(this.spsr[spsr_mode_mapping[this.processorMode]]);
    }

    public void setCpsrResult(int result) {
        this.cpsr = Utilities.clearFlag(this.cpsr, CPSR_NZ_FLAGS);
        if (result < 0) {
            this.cpsr = Utilities.setBit(this.cpsr, 31);
        } else if (result == 0) {
            this.cpsr = Utilities.setBit(this.cpsr, 30);
        }
    }

    public void setCpsrResult(int result, boolean c) {
        this.cpsr = Utilities.clearFlag(this.cpsr, CPSR_NZC_FLAGS);
        if (result < 0) {
            this.cpsr = Utilities.setBit(this.cpsr, 31);
        } else if (result == 0) {
            this.cpsr = Utilities.setBit(this.cpsr, 30);
        }
        if (c) {
            this.cpsr = Utilities.setBit(this.cpsr, 29);
        }
    }

    public void setCpsrResult(int result, boolean c, boolean v) {
        this.cpsr = Utilities.clearFlag(this.cpsr, CPSR_NZCV_FLAGS);
        if (result < 0) {
            this.cpsr = Utilities.setBit(this.cpsr, 31);
        } else if (result == 0) {
            this.cpsr = Utilities.setBit(this.cpsr, 30);
        }
        if (c) {
            this.cpsr = Utilities.setBit(this.cpsr, 29);
        }
        if (v) {
            this.cpsr = Utilities.setBit(this.cpsr, 28);
        }
    }

    public boolean hasCflag() {
        return Utilities.hasBit(this.cpsr, 29);
    }

    public void setSystemControlCoprocessorRegister(int n, int value) {
        switch (n) {
            case 1: {
                if (value != 8052) {
                    log.error((Object)String.format("setSystemControlCoprocessorRegister unimplemented control bits 0x%X", value));
                }
                this.highVectors = Utilities.hasBit(value, 13);
                break;
            }
            default: {
                log.error((Object)String.format("setSystemControlCoprocessorRegister unimplemented register=%d, value=0x%X", n, value));
            }
        }
    }

    public int getSystemControlCoprocessorRegister(int n) {
        int value;
        switch (n) {
            case 0: {
                value = 0;
                break;
            }
            default: {
                log.error((Object)String.format("getSystemControlCoprocessorRegister unimplemented register=%d", n));
                value = 0;
            }
        }
        return value;
    }
}

